/**
 * cutscene: Meet the trigger
 * storyline:
 * Daniel just got teleported from his dormitory to a weird place, and meets a trigger.
 * how we got here:
 * We trigger this scene by stepping on a trigger
 * scenario:
 * A dark place, with only a T. When we step on the T, we a trigger appears, and in a white flash, 
 * we teleport to the Kamajs settlement of Return.
 */

// We may trigger this script many times, but only run this scene once
if(!GetMapFlag('meetTheTrigger')) {

	//At this moment, the player should not be able to move.
	QCutScene_Start();
	
	// Set this flag to true, so we dont play this cutscene again.
	SetMapFlag('meetTheTrigger', true);
	
	//Clear the event markers, we want to start with a clean slate.
	ClearEventMarker();

	// Create the Trigger: Mr. T at the EntryPoint
	nQ( {
		action: 'CreatePerson',
		sprite: 'mrT',
		spriteset: 'glitch/mr_t.rss',

		// Move mr.T to the tile we want
		tx: 20,
		ty: 13,

		// Set the direction ready to emerge
		direction: 'emerge',
		frame: 0
	} );

	// Make him appear from the ground
	nQ( {
		action: 'Animate',
		sprite: 'mrT',
		direction: 'emerge',
		wait: false
	} );

	// Daniel is terrified
	Qballoon('WHAA!', 1, 'Daniel', -1);

	// ... and runs away as fast as he can
	nQ( {
		action: 'Move',
		sprite: 'Daniel',
		direction: 'west',
		tiles:4
	} );

	// Daniel looks back
	nQ(SetPersonDirection, null, "Daniel", "lookeast");

	// If the balloon is still displaying, stop displaying it.
	Qballoon(false);
	
	// Wait a little, then look towards the player
	zQ(60);
	nQ(SetPersonDirection, null, "Daniel", "looksouth");

	nQ( {
		action: 'TalkContinue', // inherit all modifications such as portrait etc from action: 'Talk'
		text: "Oh man! I hit my head really hard...",
	} );

	// We now fade to white, but we dont have this fade defined yet, lets add it:
	// Note: We are not queuing this command! note2: Due to a Sphere bug, we cant use 255 in all 4 values so we use 254 on one of them
	// The 'setwhite' (extra parameter ignored) is because at each mapchange we remove the colormask to make a screenshot (at each map entry we could auto-save)
	MapChange.defineFade('towhite', 150,150,
		function(){ SetColorMask(CreateColor(255, 255, 255, 254), 150, 'towhite'); },
		function(){ SetColorMask(CreateColor(254, 255, 255, 255),0, 'setwhite'); SetColorMask(CreateColor(0, 0, 0, 0), 150, 'fromwhite'); }
	);


	nQ({ action: 'Warp', // Move to another map
		rmp: 'kamajs/kamajs_village_return.rmp',
		mapname: "????",
		fade: 'towhite',
		warppoint: 'center',
		wait: 1 // Wait until we warped to that map and are fading in
	});

	// Look around, again!
	zQ(40);
	nQ(SetPersonDirection, null, "Daniel", "lookwest");
	zQ(20);
	nQ(SetPersonDirection, null, "Daniel", "lookeast");
	zQ(20);
	nQ(SetPersonDirection, null, "Daniel", "looksouth");

	// Wait for the fade in to complete
	wQ("!MapChange.active");

	nQ( {
		action: 'TalkContinue', // inherit all modifications such as portrait etc from action: 'Talk'
		text: "What is going on?",
		settings: {
			outtroAnim: WINDOWANIM_GROW
		},
		redraw: false // Because we animate out, we dont want to redraw after its GROWn small.
	} );

	// We now fade to white, but we dont have this fade defined yet, lets add it:
	//At this moment, the player should be able to move again.
	QCutScene_End();

	Qnarrate("And so our test comes to an end...");

	// you can also use this command to start the cutscene: CutScene_Play();
	Game.EventQueue.play('Daniel Meets Mr. T'); // ...aaaand ACTION! Now play all things we queued.
}

